function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_dAC.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(70, 1);
residual(1) = T(29)+T(32)+params(21)*y(119)-y(80);
residual(2) = T(24)*(-exp(y(26)))+y(73)*(-(T(28)*params(4)*exp(y(26)*params(4))))+exp(y(26))*y(63)+params(21)*y(121)-y(82);
residual(3) = y(72)*(-(T(27)*params(4)*exp(y(27)*params(4))))+y(68)*y(38)*T(27)*params(4)*(params(4)-1)*exp(y(27)*(params(4)-1))+exp(y(27))*y(63)+params(21)*y(120)-y(81);
residual(4) = T(24)*T(33)+y(76)*(-exp(y(28)))+exp(y(28))*y(75)+params(21)*y(123)-y(84);
residual(5) = y(76)*(-exp(y(29)))+exp(y(29))*y(74)+params(21)*y(122)-y(83);
residual(6) = T(35);
residual(7) = T(37);
residual(8) = T(38);
residual(9) = T(39);
residual(10) = params(21)*(-y(126))+T(41)+params(21)*y(118)*(-exp(y(34)))+T(42)*y(127);
residual(11) = params(21)*(-y(125))+T(36)+y(69)*T(43)+y(66)*T(44)+params(21)*y(109)*exp(y(31))*params(6)*params(5)*exp(params(5)*y(35))+T(45)+T(42)*y(128);
residual(12) = exp(y(36))*y(62);
residual(13) = y(67)*(-params(7))+y(66)+T(30)*y(19)*(-(exp(y(46))*(1-exp(y(11)))))+T(30)*exp(y(46))*y(21);
residual(14) = params(4)*exp(y(27)*(params(4)-1))*T(27)*y(68)+y(67)+T(30)*y(20)*(-(exp(y(46))*(1-params(7))));
residual(15) = T(8)*y(76)+y(59)*(-(params(11)*T(12)*T(46)))+y(58)*(-(params(11)*T(47)*T(48)));
residual(16) = y(63)*(-exp(y(40)))+y(61)*(-(T(5)*T(19)*T(16)*T(50)))+y(60)*(-(T(17)*T(3)*T(16)*T(51)))+y(59)*(-(T(14)*params(11)*T(49)))+exp(y(40))*y(58)+params(21)*y(124)-y(85);
residual(17) = T(20)*y(63)+params(21)*y(105)*(-(T(58)*T(61)))+params(21)*y(106)*(-(T(62)*(T(54)*T(64)*T(65)+T(55)*T(64)*T(67))))+params(21)*y(107)*T(71)+params(21)*y(108)*(-(exp((1-params(3))*y(99))*exp(T(1)*y(103))*params(3)*exp(params(3)*y(41))))+params(21)*y(109)*(-(T(20)*(1-params(10))));
residual(18) = (T(33)-exp(y(26)))*T(75)+y(65)*(-(params(1)*T(75)/T(26)))+T(4)*y(64)+y(62)*T(77)+y(61)*T(81)+y(60)*T(83)+y(58)*(-(T(48)*T(85)))+params(21)*y(110)*(-((-(T(75)*T(87)))/(T(24)*T(24))));
residual(19) = (T(33)-exp(y(26)))*T(88)+y(65)*T(89)+exp(y(43))*y(63)+params(21)*y(110)*(-((-(T(87)*T(88)))/(T(24)*T(24))));
residual(20) = exp(y(44))*y(61)+T(90);
residual(21) = y(64)*(-(T(21)*T(91)))+exp(y(45))*y(60);
residual(22) = T(92);
residual(23) = y(78)+params(21)*y(117)*(-params(15))+y(62)*(-(exp(y(42)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(47))))+y(61)*(-(T(5)*T(19)*T(16)*T(93)))+y(60)*(-(T(17)*T(3)*T(16)*T(94)))+y(58)*(-(T(48)*T(96)))+T(42)*(-params(16))*y(129);
residual(24) = T(99)+y(87)+params(21)*(-y(126))+y(77)+T(103);
residual(25) = y(80);
residual(26) = y(81);
residual(27) = y(82);
residual(28) = y(83);
residual(29) = y(84);
residual(30) = y(85);
residual(31) = T(24)*T(104)+exp(y(55))*y(79);
residual(32) = y(86);
residual(33) = y(87);
residual(34) = exp(y(40))-T(9)^T(10);
residual(35) = exp(y(25))-params(11)*T(12)*T(14);
residual(36) = exp(y(45))-T(3)*T(15)*T(16)*T(17);
residual(37) = exp(y(44))-T(5)*T(16)*T(18)*T(19);
residual(38) = exp(y(36))-exp(T(1)*y(47))*exp(y(13)*params(3))*exp(y(42)*(1-params(3)));
residual(39) = exp(y(43))+T(20)+exp(y(27))+exp(y(26))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(48)))*exp(y(6))-(exp(y(40))+exp(y(13))*(1-params(10)));
residual(40) = T(4)-T(21)*exp(y(45))^T(22);
residual(41) = 1-exp(y(102))*(1+exp(y(101))-params(10));
residual(42) = exp(y(46))-params(1)*T(24)/T(26);
residual(43) = y(37)-exp(y(102))*(exp(y(35))*exp(y(94))+(1-exp(y(35)))*y(95)-params(6)*exp(params(5)*y(35)));
residual(44) = y(38)-(y(37)*params(7)+exp(y(102))*(1-params(7))*y(96));
residual(45) = y(38)*params(4)*exp(y(27)*(params(4)-1))*T(27)-1;
residual(46) = T(105);
residual(47) = exp(y(31))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(33)));
residual(48) = exp(y(30))-(exp(y(6))*(1-exp((-y(48)))*exp(y(10)))+params(7)*exp(y(32)));
residual(49) = exp(y(33))-((1-params(7))*exp(y(9))+T(27)*exp(y(27)*params(4)));
residual(50) = exp(y(32))-((1-params(7))*exp(y(8))+exp(y(26)*params(4))*T(28));
residual(51) = exp(y(29))-exp(y(7))*exp(y(11));
residual(52) = exp(y(28))-exp(y(6))*exp((-y(48)))*exp(y(10));
residual(53) = T(8)-(exp(y(29))+exp(y(28)));
residual(54) = y(48)-x(it_, 1);
residual(55) = y(47)-(x(it_, 2)+params(15)*y(16)+params(16)*y(22));
residual(56) = exp(y(55))-exp(y(10));
residual(57) = y(49)-(y(25)-y(1));
residual(58) = y(50)-(y(27)-y(3));
residual(59) = y(51)-(y(26)-y(2));
residual(60) = y(52)-(y(29)-y(5));
residual(61) = y(53)-(y(28)-y(4));
residual(62) = y(54)-(y(40)-y(12));
residual(63) = y(56)-(y(11)-y(23));
residual(64) = y(57)-(y(10)-y(48)-(y(24)-y(17)));
lhs = y(88);
rhs = y(126);
residual(65) = lhs - rhs;
lhs = y(89);
rhs = y(125);
residual(66) = lhs - rhs;
lhs = y(90);
rhs = y(117);
residual(67) = lhs - rhs;
lhs = y(91);
rhs = y(16);
residual(68) = lhs - rhs;
lhs = y(92);
rhs = y(11);
residual(69) = lhs - rhs;
lhs = y(93);
rhs = y(10);
residual(70) = lhs - rhs;

end
